<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Bar Chart</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array( 
        array("y" => 7,"label" => "March" ),
        array("y" => 12,"label" => "April" ),
        array("y" => 28,"label" => "May" ),
        array("y" => 18,"label" => "June" ),
        array("y" => 41,"label" => "July" )
    );
?>

<script>
    window.onload = function() {
        var chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            title:{
                text: "Revenue Chart of Acme Corporation"
            },
            axisY: {
                title: "Revenue (in USD)",
                includeZero: true,
                prefix: "$",
                suffix:  "k"
            },
            data: [{
                type: "bar",
                yValueFormatString: "$#,##0K",
                indexLabel: "{y}",
                indexLabelPlacement: "inside",
                indexLabelFontWeight: "bolder",
                indexLabelFontColor: "white",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
    }
</script>

<?php include '../footer.php'; ?>